#'"~.,.~"'"~.,.~"'"~.,.~"'"~.,.~"'"~.,.~"'"~.,.~"#
#~	DX Platform Settings Makefile		~#
#'"~.,.~"'"~.,.~"'"~.,.~"'"~.,.~"'"~.,.~"'"~.,.~"#

#refer to this makefiles usage instructions

#set the default platform to realview
ifeq ($(PLATFORM),)
    PLATFORM = RV
endif

ifeq ($(PLATFORM),RV)
    #platform extensions
    OBJEXT = o
    LIBEXT = a
    BINEXT = axf
    MFEXT = mak
    
    #cc tool for compiling objects
    CC = armcc
    CC_PLATFORM_FLAGS =  -c --apcs /interwork --cpu $(CPU)
    CCFLAG_OPTIMIZE = -O2
    CCFLAG_INCLUDE_DIR = -I
    CCFLAG_OUTPUT = -o
    #ar tool for building libs
    AR = armar
    AR_PLATFORM_FLAGS = -c -r --create
    #ld tool for building executables
    LD = armlink
    LD_PLATFORM_FLAGS = 
    LDFLAG_OUTPUT = -o
    
    #platform shell constants
    DIR_SEP = \\
    ECHO = @echo :-+-
    IGNORE_CMD = @rem
    RM = del /Q
    MKDIR = @mkdir
    
    #platform shell using ~dynamic~ variables
    CHECK_TARGET_COMPLETE = @if exist $(TARGET) echo Build Completed - $(TARGET)
    CHECK_AUTO_TARGET_COMPLETE = @if exist $(subst _check,,$@) (echo Build Completed - $(subst _check,,$@))
    
    #set the default cpu
    ifeq ($(CPU),)
        CPU = ARM926EJ-S
    endif
endif

ifeq ($(PLATFORM),LINUX)
    #platform extensions
    OBJEXT = o
    LIBEXT = a
    BINEXT = out
    MFEXT = mak
    
    #cc tool for compiling objects
    CC = gcc
    CC_PLATFORM_FLAGS =  -c -DHASLONGLONG -g 
    CCFLAG_OPTIMIZE = -O2
    CCFLAG_INCLUDE_DIR = -I
    CCFLAG_OUTPUT = -o
    #ar tool for building libs
    AR = ar
    AR_PLATFORM_FLAGS = rcs
    #ld tool for building executables
    LD = gcc
    LD_PLATFORM_FLAGS = 
    LDFLAG_OUTPUT = -o
    
    #platform shell constants
    DIR_SEP = /
    ECHO = @echo
    IGNORE_CMD = @\#
    RM = rm -f 
    MKDIR = @mkdir --parents
    
    #platform shell using ~dynamic~ variables
    CHECK_TARGET_COMPLETE = @if [ -f $(TARGET) ]; then (echo "Build Completed - $(TARGET)"); fi;
    CHECK_AUTO_TARGET_COMPLETE = @if [ -f $(subst _check,,$@) ]; then (echo "Build Completed - $(subst _check,,$@)"); fi;
endif

ifeq ($(PLATFORM),PC_LINT)
    #platform extensions
    PC_LINTEXT = lin
    OBJEXT = $(PC_LINTEXT)
    MFEXT = mak
    
    
    CC = @-\\mozart\lint\lint-nt.exe 
    CCFLAG_OPTIMIZE = 
    CCFLAG_INCLUDE_DIR = -i
    CC_PLATFORM_FLAGS = -u +v -zero std.lnt \
        +libh(alloca.h) +libh(armdsp.h) +libh(assert.h) \
        +libh(ctype.h) +libh(deque_spec.h) +libh(dspfns.h) \
        +libh(errno.h) +libh(fenv.h) +libh(float.h) +libh(inttypes.h) \
        +libh(iso646.h) +libh(limits.h) +libh(list_spec.h) +libh(locale.h) \
        +libh(math.h) +libh(rt_fp.h) +libh(rt_heap.h) +libh(rt_locale.h) \
        +libh(rt_misc.h) +libh(rt_sys.h) +libh(setjmp.h) +libh(signal.h) \
        +libh(stdarg.h) +libh(stdbool.h) +libh(stddef.h) +libh(stdint.h) \
        +libh(stdio.h) +libh(stdlib.h) +libh(string.h) +libh(time.h) \
        +libh(vector_spec.h) +libh(wchar.h) +libh(wctype.h) \
        $(CCFLAG_INCLUDE_DIR)$(LIBRARY_INCLUDE_PATH)
    CCFLAG_OUTPUT = >
    
    #platform shell constants
    DIR_SEP = \\
    ECHO = @echo :-+-
    IGNORE_CMD = @rem
    RM = del /Q
    MKDIR = @mkdir
    
endif

#set the debug echo if DEBUG flag is not empty, otherwise ignores it
DEBUG_ECHO = $(ECHO)
ifeq ($(DEBUG),)
    DEBUG_ECHO = $(IGNORE_CMD) $(ECHO)
endif

#set the default VOS os to NoOs
ifeq ($(VOS_OS),)
    VOS_OS = NoOs
endif

#set the default FVOS os to NoOs
ifeq ($(FVOS_OS_DIR),)
    FVOS_OS_DIR = FVOS_NoOS
endif

#set the NVS type to files
ifeq ($(NVS_TYPE),)
    NVS_TYPE = Files
endif

PLAT_debug:
	$(ECHO) PLATFORM debug info-
	$(ECHO) OBJEXT $(OBJEXT)
	$(ECHO) LIBEXT $(LIBEXT)
	$(ECHO) BINEXT $(BINEXT)
	$(ECHO) MFEXT $(MFEXT)
	$(ECHO) CC $(CC)
	$(ECHO) CC_PLATFORM_FLAGS $(CC_PLATFORM_FLAGS)
	$(ECHO) CCFLAG_OPTIMIZE $(CCFLAG_OPTIMIZE)
	$(ECHO) CCFLAG_INCLUDE_DIR $(CCFLAG_INCLUDE_DIR)
	$(ECHO) CCFLAG_OUTPUT $(CCFLAG_OUTPUT)
	$(ECHO) AR $(AR)
	$(ECHO) AR_PLATFORM_FLAGS $(AR_PLATFORM_FLAGS)
	$(ECHO) LD $(LD)
	$(ECHO) LD_PLATFORM_FLAGS $(LD_PLATFORM_FLAGS)
	$(ECHO) LDFLAG_OUTPUT $(LDFLAG_OUTPUT)
